close all

iseed = 0;
repeats = 10;
logt = 4;
lognc = 6;
sLL = 28;
dt = 10;
measvalues = {'r','dpq','K','Y'};
Lvalues = [50,80];
Lmarkers = {'rx-','bx-'};
formatSpec = '%f';

t(1)=10;
for i=1:20
    t(i+1)=i*100;
end

for i=1:5
    t(21+i)=2000+i*1000;
end

for i=1:21
    t(26+i)=8000+(i-1)*100;
end

for j=1:2
L=Lvalues(j);
for k=1:4
A=zeros(1,49);
for seed=iseed:iseed+repeats-1
meas = measvalues{k};
FILENAME = sprintf('%d%sAve1,%d,%d,%d,%d,%d.txt',seed,meas,logt,L,lognc,sLL,dt);
fileID = fopen(FILENAME,'r');

if meas=='dpq'
    meas='|dpq|^2';
end

if meas=='Y'
    meas='\Upsilon';
end


A = A + fscanf(fileID,formatSpec)/repeats;

if seed==iseed+repeats-1
  figure(k)
  hold on, plot(t,A(1:47)/L,Lmarkers{j},'MarkerSize',12,'LineWidth',4);
  xlim([0,10000]);
  maxA=max(A(1:47)/L);
  ylim([0,1.2*maxA]);
  xlabel('Time');
  yname = sprintf('P_{ave}(%s)/L',meas);
  ylabel(yname);
  set(gca, 'FontSize', 20);
  
if strcmp(meas,'|dpq|^2')==1
    meas='dpq';
end

if strcmp(meas,'\Upsilon')==1
    meas='Y';
end

plotname = sprintf('%sAve1,%d,%d,%d,%d.png',meas,logt,lognc,sLL,dt);
saveas(gcf,plotname);

figure(k+size(measvalues,2))
hold on, plot(10000-t,A(1:47)/L,Lmarkers{j},'MarkerSize',12,'LineWidth',4);
set(gca,'xscale','log')
xlim([100,5000]);
maxA=max(A(1:47)/L);
ylim([0,1.2*maxA]);
xlabel('t_{obs}-t');
ylabel(yname);
set(gca, 'FontSize', 20);


plotname = sprintf('logsc%sAve1,%d,%d,%d,%d.png',meas,logt,lognc,sLL,dt);
saveas(gcf,plotname);

end
end
end
end